﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ import Namespace="System.Linq" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">
    
    public enum Zakres {
        [Caption("bez FP")]
        BezFP,
        [Caption("z FP")]
        ZFP,
        Wszyscy
    }

    public class Params : ContextBase {
        public Params(Context context) : base(context) {
        }

        Zakres osoby = Zakres.BezFP;
        [Caption("Pokazuj osoby")]
        public Zakres Osoby {
            get { return osoby; }
            set {
                osoby = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }
        
    private Dictionary<Pracownik, List<Wyplata>> dane = new Dictionary<Pracownik, List<Wyplata>>();
    private Date aktualny = Date.Empty;

    class PracownikComparer : IComparer<Pracownik> {
        public int Compare(Pracownik x, Pracownik y) {
            int result = x.NazwiskoImię.CompareTo(y.NazwiskoImię);
            if (result == 0)
                result = x.Kod.CompareTo(y.Kod);
            return result;
        }
    }
      
    protected void dc_ContextLoad(object sender, EventArgs e) {
        FromTo okres = ((OkresContext)dc[typeof(OkresContext)]).Okres;
        aktualny = ((ActualDate)dc[typeof(ActualDate)]).Actual;
        ReportHeader["OKRES"] = okres.ToString();
        ReportHeader["TYP"] = CaptionAttribute.EnumToString(pars.Osoby);

        List<Wyplata> wyplaty;
        Row[] rows = (Row[])dc[typeof(Row[])];
        foreach (ListaPlac lista in rows)
            foreach (Wyplata wyplata in lista.Wyplaty)
                if (!dane.TryGetValue(wyplata.Pracownik, out wyplaty)) {
                    wyplaty = new List<Wyplata>();
                    wyplaty.Add(wyplata);
                    dane.Add(wyplata.Pracownik, wyplaty);
                }
                else
                    wyplaty.Add(wyplata);

        List<Pracownik> result = new List<Pracownik>(dane.Keys);
        result.Sort(new PracownikComparer());
        Grid1.DataSource = result;
    }

    protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
        List<string> wydzialy = new List<string>();
        Pracownik pracownik = (Pracownik)args.Row;

        decimal podstawa = 0;
        decimal kwotaFP = 0;
        bool any = false;

        List<Wyplata> wyplaty = dane[pracownik];
        foreach (Wyplata w in wyplaty) {
            decimal podstawaW = 0;
            decimal kwotaFPW = 0;
            foreach (WypElement e in w.Elementy) {
                if(e.StanStorna == StanStornaElementu.Stornujący)
                    podstawaW += System.Math.Min(e.Podatki.Chorobowa.Podstawa, e.Podatki.Wypadkowa.Podstawa);
                else
                    podstawaW += System.Math.Max(e.Podatki.Chorobowa.Podstawa, e.Podatki.Wypadkowa.Podstawa);
                kwotaFPW += e.Podatki.FP.Skladka;
            }
            if (kwotaFPW != 0) {
                if (pars.Osoby == Zakres.BezFP)
                    continue;
            }
            else {
                if (pars.Osoby == Zakres.ZFP)
                    continue;
            }
            podstawa += podstawaW;
            kwotaFP += kwotaFPW;
            any = true;
        }
        colChor.EditValue = podstawa;
        colFP.EditValue = kwotaFP;        
        if (pracownik[aktualny].Etat != null && pracownik[aktualny].Etat.Wydzial != null)
            wydzialy.Add(pracownik[aktualny].Etat.Wydzial.Kod);
        wydzialy.AddRange(wyplaty.Where(_ => _.Typ == TypWyplaty.Umowa).Select(_ => _.ListaPlac.Wydzial.Kod));
        wydzialy = wydzialy.Distinct().OrderBy(q => q).ToList();
        colWydzial.EditValue = string.Join(",", wydzialy);

        args.VisibleRow = any;
    }
</script>

<HTML>
	<HEAD>
		<TITLE>Zestawiene pracowników zwolnionych ze składek na Fundusz Pracy</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" 
                title="Zestawienie pracowników|</strong>Za okres: <strong>%OKRES%|</strong>Osoby: <strong>%TYP%"></eb:ReportHeader>
			<ea:Grid id="Grid1" runat="server" 
                RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace" 
                onbeforerow="Grid1_BeforeRow">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="NazwiskoImię" 
                        Caption="Pracownik"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Kod" Caption="Kod" 
                        Width="16"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" 
                        ID="colWydzial" Caption="Wydział" Width="30" Total="Info"></ea:GridColumn>
                    <ea:GridColumn ID="colChor" runat="server" 
                        Caption="Podstawa składek na ubezpieczenia chorobowe i wypadkowe" 
                        Width="16" Align="Right" Format="{0:n}" Total="Sum">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colFP" runat="server" 
                        Caption="Kwota FP" 
                        Width="16" Align="Right" Format="{0:n}" Total="Sum">
                    </ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

